/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mcld.CoreAudio.Triangle;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.swing.JPanel;
import uk.co.mcld.CoreAudio.Triangle.Triangle;
import uk.co.mcld.CoreAudio.Triangle.TriangleComponentGeneric;

public abstract class TriangleComponent
extends JPanel {
    private Triangle theTriangle;
    protected Triangle theSoundingTriangle;
    private boolean drawing = false;
    private Mutable2DArray drawnPoints;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private Font introFont = new Font(null, 0, 14);
    private Graphics2D g;
    private static final Color darkOrange = new Color(Color.HSBtoRGB(0.1f, 0.9f, 0.9f));
    private static final Color white = new Color(1.0f, 1.0f, 1.0f);
    private static final Color blue = new Color(0.0f, 0.0f, 0.5f);
    private static final Color gray = new Color(0.5f, 0.5f, 0.5f);
    private boolean needToRepaintBackground = true;
    private boolean justPaintedIntro = false;

    public TriangleComponent() {
        super(true);
        this.drawnPoints = new Mutable2DArray();
        this.setUpAudioOutput();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TriangleComponent.this.drawnPoints.clear();
                TriangleComponent.this.minX = (TriangleComponent.this.maxX = mouseEvent.getX());
                TriangleComponent.this.minY = (TriangleComponent.this.maxY = mouseEvent.getY());
                TriangleComponent.this.drawnPoints.add(TriangleComponent.this.minX, TriangleComponent.this.minY);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (TriangleComponent.this.drawing && TriangleComponent.this.drawnPoints.length() > 2) {
                    TriangleComponent.this.drawing = false;
                    int n = ((TriangleComponent)TriangleComponent.this).drawnPoints.x[0];
                    int n2 = TriangleComponent.this.minY;
                    int n3 = 10000;
                    int n4 = 10000;
                    int n5 = -1;
                    int n6 = -1;
                    for (int i = 0; i < TriangleComponent.this.drawnPoints.length(); ++i) {
                        int n7 = TriangleComponent.this.nonPythagDist(((TriangleComponent)TriangleComponent.this).drawnPoints.x[i], ((TriangleComponent)TriangleComponent.this).drawnPoints.y[i], TriangleComponent.this.minX, TriangleComponent.this.maxY);
                        int n8 = TriangleComponent.this.nonPythagDist(((TriangleComponent)TriangleComponent.this).drawnPoints.x[i], ((TriangleComponent)TriangleComponent.this).drawnPoints.y[i], TriangleComponent.this.maxX, TriangleComponent.this.maxY);
                        if (n7 < n3) {
                            n3 = n7;
                            n5 = i;
                        }
                        if (n8 >= n4) continue;
                        n4 = n8;
                        n6 = i;
                    }
                    TriangleComponent.this.theTriangle = new Triangle(n, n2, ((TriangleComponent)TriangleComponent.this).drawnPoints.x[n5], ((TriangleComponent)TriangleComponent.this).drawnPoints.y[n5], ((TriangleComponent)TriangleComponent.this).drawnPoints.x[n6], ((TriangleComponent)TriangleComponent.this).drawnPoints.y[n6]);
                    TriangleComponent.this.drawnPoints.clear();
                    TriangleComponent.this.needToRepaintBackground = true;
                    TriangleComponent.this.repaint();
                    TriangleComponent.this.needToRepaintBackground = true;
                    TriangleComponent.this.repaint();
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                TriangleComponent.this.drawing = false;
                if (TriangleComponent.this.theTriangle != null) {
                    TriangleComponent.this.theSoundingTriangle = TriangleComponent.this.theTriangle;
                    TriangleComponent.this.theSoundingTriangle.strike(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                TriangleComponent.this.drawing = true;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TriangleComponent.this.drawnPoints.add(n, n2);
                if (n < TriangleComponent.this.minX) {
                    TriangleComponent.this.minX = n;
                } else if (n > TriangleComponent.this.maxX) {
                    TriangleComponent.this.maxX = n;
                }
                if (n2 < TriangleComponent.this.minY) {
                    TriangleComponent.this.minY = n2;
                } else if (n2 > TriangleComponent.this.maxY) {
                    TriangleComponent.this.maxY = n2;
                }
            }
        };
        this.addMouseMotionListener(mouseMotionAdapter);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TriangleComponent.this.makeSureToRepaintEverything();
                TriangleComponent.this.repaint();
            }

            public void componentShown(ComponentEvent componentEvent) {
                TriangleComponent.this.makeSureToRepaintEverything();
                TriangleComponent.this.repaint();
            }
        });
    }

    protected abstract void setUpAudioOutput();

    public void paint(Graphics graphics) {
        this.g = (Graphics2D)graphics;
        if (this.needToRepaintBackground) {
            this.g.setPaint(white);
            this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.g.setFont(this.introFont);
            this.g.setPaint(blue);
            this.g.drawString("The Electronic Triangle", 40, 40);
            this.g.setPaint(gray);
            this.g.drawString("by Dan Stowell", 40, 55);
            this.g.drawString("based on a dream by Philippa Law", 40, 70);
            this.g.setPaint(darkOrange);
            this.g.drawString("Draw a triangle with your mouse.", 40, 100);
            this.g.drawString("Then hit it!", 40, 115);
            this.needToRepaintBackground = false;
        }
        if (this.theTriangle != null) {
            this.theTriangle.paint(graphics);
        }
    }

    public void makeSureToRepaintEverything() {
        this.needToRepaintBackground = true;
        this.justPaintedIntro = false;
    }

    public abstract void startAudioOutput();

    public abstract void stopAudioOutput();

    public int nonPythagDist(int n, int n2, int n3, int n4) {
        return Math.abs(n - n3) + Math.abs(n2 - n4);
    }

    public static void plumbSoundSystem() {
        TriangleComponent.echo("------------------------------------------------------------");
        TriangleComponent.echo("PLUMBING THE SOUND SYSTEM...");
        TriangleComponent.echo("Desired audio format: " + TriangleComponentGeneric.genericAudioFormat);
        TriangleComponent.echo("");
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            TriangleComponent.echo("MIXER " + i + ":");
            TriangleComponent.echo(" " + mixer);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo();
            for (int j = 0; j < infoArray2.length; ++j) {
                TriangleComponent.echo("    Line " + j + ":");
                TriangleComponent.echo("     " + infoArray2[j]);
                TriangleComponent.echo("        The desired AudioFormat " + (((DataLine.Info)infoArray2[j]).isFormatSupported(TriangleComponentGeneric.genericAudioFormat) ? "IS" : "is NOT") + " supported.");
            }
        }
        TriangleComponent.echo("------------------------------------------------------------");
    }

    public static void echo(String string) {
        System.out.println(string);
    }

    public class Mutable2DArray {
        public int[] x;
        public int[] y;
        public int initSize = 32;
        private int pointer;

        public Mutable2DArray() {
            this.clear();
        }

        public void clear() {
            this.x = new int[this.initSize];
            this.y = new int[this.initSize];
            this.pointer = 0;
        }

        public int length() {
            return this.pointer;
        }

        public void add(int n, int n2) {
            if (this.pointer >= this.x.length) {
                int[] nArray = new int[this.x.length * 2];
                int[] nArray2 = new int[this.y.length * 2];
                for (int i = 0; i < this.x.length; ++i) {
                    nArray[i] = this.x[i];
                    nArray2[i] = this.y[i];
                }
                this.x = nArray;
                this.y = nArray2;
            }
            this.x[this.pointer] = n;
            this.y[this.pointer] = n2;
            ++this.pointer;
        }
    }
}

