/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mcld.CoreAudio.Triangle;

import com.apple.audio.hardware.AudioDevice;
import com.apple.audio.hardware.AudioDeviceIOProc;
import com.apple.audio.hardware.AudioHardware;
import com.apple.audio.util.AudioBuffer;
import com.apple.audio.util.AudioBufferList;
import com.apple.audio.util.AudioTimeStamp;
import com.apple.audio.util.CAMemoryObject;
import java.util.Arrays;
import uk.co.mcld.CoreAudio.Triangle.TriangleComponent;

public class TriangleComponentMac
extends TriangleComponent {
    private AudioDevice outDevice;
    private AudioDeviceIOProc outProc;
    private AudioBuffer outBuf;
    private CAMemoryObject outData;
    private float[] floatBuf;
    private int numOutputChannels;

    protected void setUpAudioOutput() {
        this.floatBuf = new float[1024];
        Arrays.fill(this.floatBuf, 0.0f);
        try {
            this.outDevice = AudioHardware.getDefaultOutputDevice();
            this.outProc = new AudioDeviceIOProc(){

                public synchronized int execute(AudioDevice audioDevice, AudioTimeStamp audioTimeStamp, AudioBufferList audioBufferList, AudioTimeStamp audioTimeStamp2, AudioBufferList audioBufferList2, AudioTimeStamp audioTimeStamp3) {
                    TriangleComponentMac.this.outBuf = audioBufferList2.getBuffer(0);
                    TriangleComponentMac.this.outData = TriangleComponentMac.this.outBuf.getData();
                    float f = 0.0f;
                    if (TriangleComponentMac.this.theSoundingTriangle == null) {
                        Arrays.fill(TriangleComponentMac.this.floatBuf, 0.0f);
                    } else {
                        TriangleComponentMac.this.numOutputChannels = TriangleComponentMac.this.outBuf.getNumberOfChannels();
                        for (int i = 0; i < TriangleComponentMac.this.floatBuf.length; ++i) {
                            f = TriangleComponentMac.this.theSoundingTriangle.getSignal();
                            if (TriangleComponentMac.this.numOutputChannels == 1) {
                                ((TriangleComponentMac)TriangleComponentMac.this).floatBuf[i] = f;
                                continue;
                            }
                            if (TriangleComponentMac.this.numOutputChannels == 2) {
                                int n = i++;
                                float f2 = f;
                                ((TriangleComponentMac)TriangleComponentMac.this).floatBuf[i] = f2;
                                ((TriangleComponentMac)TriangleComponentMac.this).floatBuf[n] = f2;
                                continue;
                            }
                            for (int j = 0; j < TriangleComponentMac.this.numOutputChannels; ++j) {
                                ((TriangleComponentMac)TriangleComponentMac.this).floatBuf[i + j] = f;
                            }
                            i += TriangleComponentMac.this.numOutputChannels - 1;
                        }
                    }
                    TriangleComponentMac.this.outData.copyFromArray(0, TriangleComponentMac.this.floatBuf, 0, TriangleComponentMac.this.floatBuf.length);
                    TriangleComponentMac.this.repaint();
                    return 0;
                }
            };
            this.outDevice.addIOProc(this.outProc);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void startAudioOutput() {
        try {
            this.outDevice.start(this.outProc);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void stopAudioOutput() {
        try {
            this.outDevice.stop(this.outProc);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

