/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mcld.CoreAudio.Triangle;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import uk.co.mcld.CoreAudio.Triangle.TriangleComponent;
import uk.co.mcld.CoreAudio.Triangle.TriangleComponentGeneric;

public class TheElectronicTriangle
extends JFrame {
    private TriangleComponent tri;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    static /* synthetic */ Class class$uk$co$mcld$CoreAudio$Triangle$TheElectronicTriangle;

    public static void main(String[] stringArray) {
        new TheElectronicTriangle();
    }

    public TheElectronicTriangle() {
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setBounds(dimension.width / 10, dimension.height / 10, dimension.width * 4 / 5, dimension.height * 4 / 5);
        this.setTitle("The Electronic Triangle");
        if (MAC_OS_X) {
            this.tri = new TriangleComponentGeneric();
            this.getContentPane().add(this.tri);
        } else {
            this.tri = new TriangleComponentGeneric();
            this.getContentPane().add(this.tri);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TheElectronicTriangle.this.quitAction();
            }
        });
        this.macOSXRegistration();
        this.repaint();
        this.setVisible(true);
        this.repaint();
        this.tri.startAudioOutput();
    }

    public void quitAction() {
        this.tri.stopAudioOutput();
        System.exit(0);
    }

    public void macOSXRegistration() {
        if (MAC_OS_X) {
            try {
                Object object;
                Class<?> clazz = Class.forName("uk.co.mcld.CoreAudio.Triangle.OSXAdapter");
                Class[] classArray = new Class[]{class$uk$co$mcld$CoreAudio$Triangle$TheElectronicTriangle == null ? (class$uk$co$mcld$CoreAudio$Triangle$TheElectronicTriangle = TheElectronicTriangle.class$("uk.co.mcld.CoreAudio.Triangle.TheElectronicTriangle")) : class$uk$co$mcld$CoreAudio$Triangle$TheElectronicTriangle};
                Method method = clazz.getDeclaredMethod("registerMacOSXApplication", classArray);
                if (method != null) {
                    object = new Object[]{this};
                    method.invoke(clazz, object);
                }
                classArray[0] = Boolean.TYPE;
                object = clazz.getDeclaredMethod("enablePrefs", classArray);
                if (object != null) {
                    Object[] objectArray = new Object[]{Boolean.TRUE};
                    object.invoke(clazz, objectArray);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + noClassDefFoundError + ")");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + classNotFoundException + ")");
            }
            catch (Exception exception) {
                System.err.println("Exception while loading the OSXAdapter:");
                exception.printStackTrace();
            }
        }
    }

    public void about() {
        JOptionPane.showMessageDialog(this, "\nThe Electronic Triangle - (C) 2004 Dan Stowell\n(Based on a dream by Philippa Law.)\n\nThe Electronic Triangle allows you to use your mouse to draw a triangle\nonscreen, and then \"hit\" it by clicking on it.\n\nTechnically, the triangle that you draw is made up of three simple Newtonian resonators\n(which act almost exactly like stiff springs). The length of the bar determines\nthe \"spring constant\" (the \"stiffness\" of the spring) and therefore the pitch that they\nresonate at.\n\nThe three Newtonian resonators are \"coupled\" together - the vibration in bar #1 affects the\nvibration of bar #2, etc. This simulates the way the resonances are coupled in a real \nmusical triangle.\n\nThe main difference is that you can experiment with different sizes and shapes of triangle!\n\nFor more information visit Dan's website:\n  http://www.mcld.co.uk", "About The Electronic Triangle", 1);
    }

    public void preferences() {
    }

    public void quit() {
        this.quitAction();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

