/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mcld.CoreAudio.Triangle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class Triangle {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int x3;
    private int y3;
    private float length1;
    private float length2;
    private float length3;
    private int bbXMin;
    private int bbXMax;
    private int bbYMin;
    private int bbYMax;
    private int bbYLine;
    private int bbXLine;
    private float pos1;
    private float pos2;
    private float pos3;
    private float acc1;
    private float acc2;
    private float acc3;
    private float springc1;
    private float springc2;
    private float springc3;
    private static final float lengthFactor = 40.0f;
    private static float couplingc = 0.02f;
    private static final float dampingc = 0.9999f;
    public static final Color[] rainbow = new Color[50];
    public static final Color[] rainbowDark = new Color[50];
    private BasicStroke triangleStroke;
    private BasicStroke triangleStrokeThick;
    private Graphics2D g;

    public Triangle(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        for (n7 = 0; n7 < rainbow.length; ++n7) {
            Triangle.rainbow[n7] = new Color(Color.HSBtoRGB(((float)rainbow.length - (float)n7) / (float)rainbow.length * 1.0f + 0.1f, 0.35f, 0.9f));
            Triangle.rainbowDark[n7] = new Color(Color.HSBtoRGB(((float)rainbow.length - (float)n7) / (float)rainbow.length * 1.0f + 0.1f, 0.35f, 0.6f));
        }
        this.triangleStroke = new BasicStroke(25.0f);
        this.triangleStrokeThick = new BasicStroke(27.0f);
        if (n4 < n2) {
            n7 = n4;
            n4 = n2;
            n2 = n7;
            n7 = n3;
            n3 = n;
            n = n7;
        }
        if (n6 < n2) {
            n7 = n6;
            n6 = n2;
            n2 = n7;
            n7 = n5;
            n5 = n;
            n = n7;
        }
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
        this.x3 = n5;
        this.y3 = n6;
        this.length1 = Math.max(2.0f, Triangle.distance(n, n2, n3, n4));
        this.length2 = Math.max(2.0f, Triangle.distance(n3, n4, n5, n6));
        this.length3 = Math.max(2.0f, Triangle.distance(n5, n6, n, n2));
        this.springc1 = Math.min(2.0f, 40.0f / this.length1);
        this.springc2 = Math.min(2.0f, 40.0f / this.length2);
        this.springc3 = Math.min(2.0f, 40.0f / this.length3);
        this.pos3 = 0.0f;
        this.pos2 = 0.0f;
        this.pos1 = 0.0f;
        this.acc3 = 0.0f;
        this.acc2 = 0.0f;
        this.acc1 = 0.0f;
        this.bbXMin = Math.min(n, Math.min(n3, n5));
        this.bbXMax = Math.max(n, Math.max(n3, n5));
        this.bbYMin = Math.min(n2, Math.min(n4, n6));
        this.bbYMax = Math.max(n2, Math.max(n4, n6));
        this.bbXLine = n;
        this.bbYLine = Math.min(n4, n6);
        float f = Math.min(25.0f, (float)(Math.min(this.bbXMax - this.bbXMin, this.bbYMax - this.bbYMin) / 5));
        this.triangleStroke = new BasicStroke(f);
        this.triangleStrokeThick = new BasicStroke(f * 1.1f);
        this.bbXMin -= 5;
        this.bbXMax += 5;
        this.bbYMin -= 5;
        this.bbYMax += 5;
    }

    public float getSignal() {
        this.acc1 = (this.acc1 - this.springc1 * this.pos1 + couplingc * this.pos2) * 0.9999f;
        this.acc2 = (this.acc2 - this.springc2 * this.pos2 + couplingc * (this.pos1 + this.pos3)) * 0.9999f;
        this.acc3 = (this.acc3 - this.springc3 * this.pos3 + couplingc * this.pos2) * 0.9999f;
        this.pos1 = Math.max(-1.0f, Math.min(1.0f, this.pos1 + this.acc1));
        this.pos2 = Math.max(-1.0f, Math.min(1.0f, this.pos2 + this.acc2));
        this.pos3 = Math.max(-1.0f, Math.min(1.0f, this.pos3 + this.acc3));
        return this.pos1 + this.pos2 + this.pos3;
    }

    public boolean strike(int n, int n2) {
        if (n2 > this.bbYMax || n2 < this.bbYMin || n > this.bbXMax || n < this.bbXMin) {
            return false;
        }
        if (n2 >= this.bbYLine) {
            this.pos2 += 0.7f;
        } else if (n < this.bbXLine) {
            this.pos1 += 0.7f;
        } else {
            this.pos3 += 0.7f;
        }
        return true;
    }

    public String toString() {
        return "Triangle [" + this.x1 + "," + this.y1 + "] [" + this.x2 + "," + this.y2 + "] [" + this.x3 + "," + this.y3 + "]";
    }

    public void paint(Graphics graphics) {
        this.g = (Graphics2D)graphics;
        this.g.setStroke(this.triangleStrokeThick);
        this.g.setPaint(Triangle.getDarkRainbowColour(this.pos1));
        this.g.drawLine(this.x1, this.y1, this.x2, this.y2);
        this.g.setStroke(this.triangleStroke);
        this.g.setPaint(Triangle.getRainbowColour(this.pos1));
        this.g.drawLine(this.x1, this.y1, this.x2, this.y2);
        this.g.setStroke(this.triangleStrokeThick);
        this.g.setPaint(Triangle.getDarkRainbowColour(this.pos2));
        this.g.drawLine(this.x2, this.y2, this.x3, this.y3);
        this.g.setStroke(this.triangleStroke);
        this.g.setPaint(Triangle.getRainbowColour(this.pos2));
        this.g.drawLine(this.x2, this.y2, this.x3, this.y3);
        this.g.setStroke(this.triangleStrokeThick);
        this.g.setPaint(Triangle.getDarkRainbowColour(this.pos3));
        this.g.drawLine(this.x3, this.y3, this.x1, this.y1);
        this.g.setStroke(this.triangleStroke);
        this.g.setPaint(Triangle.getRainbowColour(this.pos3));
        this.g.drawLine(this.x3, this.y3, this.x1, this.y1);
    }

    public static float distance(int n, int n2, int n3, int n4) {
        float f = n - n3;
        float f2 = n2 - n4;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static Color getRainbowColour(float f) {
        if (f == 0.0f) {
            return rainbow[24];
        }
        if (f <= -1.0f) {
            return rainbow[0];
        }
        if (f >= 1.0f) {
            return rainbow[49];
        }
        return rainbow[(int)Math.floor((f + 1.0f) * 25.0f)];
    }

    public static Color getDarkRainbowColour(float f) {
        if (f == 0.0f) {
            return rainbowDark[24];
        }
        if (f <= -1.0f) {
            return rainbowDark[0];
        }
        if (f >= 1.0f) {
            return rainbowDark[49];
        }
        return rainbowDark[(int)Math.floor((f + 1.0f) * 25.0f)];
    }

    public static void main(String[] stringArray) {
        System.out.println("\"Triangle\" is not the main class. Run \"TheElectronicTriangle\" instead!");
    }

    public void echo(String string) {
        System.out.println(string);
    }
}

